
// Allow editing of a factory's orientation list input. Clicking on a
// section will flip it, and the editor also supports dragging the seam point
// of a closed section to a new seam location.

function EditOrientations( curves, factory, whichinput, options )
{
	var eventhandler = options ? options.eventhandler : false;

	var editor = moi.ui.createOrientationEditor( curves, factory, whichinput );
	
	while ( 1 )
	{
		if ( !editor.waitForEvent() )
			return false;
			
		var event = editor.event;
			
		if ( event == 'done' )
			break;
			
		if ( eventhandler && eventhandler( editor ) )
			break;
	}
	
	return true;
}
